################################################################################
###Metabolomics
################################################################################


###Set your work directory
setwd("E:/Nemawork/Projects/Metabolomics")
workwd <- getwd()
filename <- "mQTL"

###Load pre-made functions
    #uses eQTL pipeline functions https://git.wur.nl/mark_sterken/eQTL_pipeline
    #     transcriptomics functions https://git.wur.nl/mark_sterken/Transcriptomics.workbench
git_dir <- "E:/Nemawork/Projects_R_zone/Git"
source(paste(git_dir,"/Loader_git.R",sep=""))

###Set data locations
support_git_dir <- paste(git_dir,"/Metabolomics/Supporting_files/",sep="")

###Load convenience functions
source(paste(support_git_dir,"../Supporting_scripts/convenience_functions.R",sep=""))



################################################################################
###Dependencies
################################################################################

install <- FALSE
#.libPaths(.libPaths("C:/Program Files/R/R-3.4.2/library"))
if(install){
    install.packages("tidyverse")
    install.packages("colorspace")
    install.packages("RColorBrewer")
    install.packages("BiocInstaller",repos="http://bioconductor.org/packages/3.3/bioc")
    source("http://www.bioconductor.org/biocLite.R") ; biocLite("limma") ; biocLite("statmod"); biocLite("KEGGREST")
    install.packages("gridExtra")
    install.packages("VennDiagram")
    install.packages("openxlsx")
    install.packages("rmarkdown")
    install.packages("lme4")
    
}

###load
    library("colorspace")
    library("RColorBrewer")
    library(limma)
    library(gridExtra)
    library("VennDiagram")
    library(openxlsx)
    library("rmarkdown")
    library(tidyverse)
    library(lme4)
    library(KEGGREST)


################################################################################
###Plotting theme, colours
################################################################################


###Set plotting theme
    presentation <- theme(axis.text.x = element_text(size=10, face="bold", color="black"),
                          axis.text.y = element_text(size=10, face="bold", color="black"),
                          axis.title.x = element_text(size=12, face="bold", color="black"),
                          axis.title.y = element_text(size=12, face="bold", color="black"),
                          strip.text.x = element_text(size=12, face="bold", color="black"),
                          strip.text.y = element_text(size=12, face="bold", color="black"),
                          plot.title = element_text(size=14, face="bold"),
                          strip.background = element_rect(fill= "grey80",color="black"),
                          panel.background = element_rect(fill = "white",color="black"),
                          panel.grid.major = element_line(colour = "grey80"),
                          panel.grid.minor = element_blank(),
                          legend.position = "right")


    blank_theme <- theme(plot.background = element_blank(),
                         panel.grid.major = element_blank(),
                         panel.grid.minor = element_blank(),
                         panel.border = element_blank(),
                         panel.background = element_blank(),
                         axis.title.x = element_blank(),
                         axis.title.y = element_blank(),
                         axis.text.x = element_blank(),
                         axis.text.y = element_blank(),
                         axis.ticks = element_blank())


###Here you can set colours for plotting in theme using ggplot2
    #display.brewer.all()
    myColors <- c(brewer.pal(12,"Paired")[c(8,2,8,2,7,1)],brewer.pal(9,"Set1")[9])
    
    names(myColors) <- c("PL_N2","PL_CB4856","N2","CB4856","IL_N2","IL_CB4856","RIL")
    
    
    colScale <- scale_colour_manual(name = "Genotype",values = myColors)
    fillScale <- scale_fill_manual(name = "Genotype",values = myColors)
    

    
################################################################################
###Dataprep
    
    ###If from scratch
    #source(paste(support_git_dir,"../Supporting_scripts/load_normalized_data.R",sep=""))
        
    ###Or, if already normalized
    load(paste(support_git_dir,"obj_Metabolomics_normalized_data.Rdata",sep=""))
    
    currents <- dir(paste(git_dir,"/WormQTL_III/supporting_files/current/",sep=""))
        popmap <- data.matrix(read.delim(file=paste(git_dir,"/WormQTL_III/supporting_files/current/",currents[grepl("WUR_populations",currents) & grepl("map",currents)],sep=""),row.names=1))
        popmrk <- read.delim(file=paste(git_dir,"/WormQTL_III/supporting_files/current/",currents[grepl("WUR_populations",currents) & grepl("marker",currents)],sep=""))
    
    ###CBN subset (unpublished)  
    source(paste(support_git_dir,"../Supporting_scripts/load_CBN_map.R",sep=""))
        
    
################################################################################
###Supplementary: starting materials ###########################################
    
    write.xlsx(cbind(popmrk,popmap[,tolower(colnames(popmap)) %in% tolower(unique(Metabolomics_normalized_data$strain))]),file="Supplementary_file_1-WN_strains.xlsx")
        
        
    sfile2 <- filter(Metabolomics_normalized_data,trait_transformation != "Abs.zscore") %>%
              mutate(trait_transformation = ifelse(trait_transformation=="Perc.zscore","Relative_batch_zscore",
                                              ifelse(trait_transformation=="Perc.batch","Relative_batch",
                                                ifelse(trait_transformation=="Perc.strain","Relative",
                                                  ifelse(trait_transformation=="Abs.conc","Absolute",
                                                    ifelse(trait_transformation=="Abs.batch","Absolute_batch",NA)))))) %>%
              arrange(batch,Data_type,trait_transformation,metabolite,strain,biological)
        
        
        
    write.xlsx(sfile2,file="Supplementary_file_2-Experimental_data.xlsx")
    
    Metabolomics_summary <- group_by(sfile2,trait_transformation,metabolite,strain) %>%
                            filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%   
                            summarise(value=mean(value,na.rm=T)) %>%
                            mutate(value=ifelse(trait_transformation != "Relative_batch_zscore" & value < 0,NA,value)) %>%
                            group_by(trait_transformation,metabolite) %>%
                            summarise(met_max=max(value,na.rm=T),met_min=min(value,na.rm=T),met_mean=mean(value,na.rm=T)) %>%
                            data.frame() %>%
                            mutate(fold=met_max/met_min) %>%
                            arrange(trait_transformation,metabolite)

    write.xlsx(Metabolomics_summary,file="Supplementary_file_2B-Summary_experimental_data.xlsx")
    

    ###Check question reviewer 3
    group_by(Metabolomics_normalized_data,batch,biological) %>%
    filter(!duplicated(strain)) %>%
    select(batch,strain) %>%
    group_by(strain) %>%
    mutate(n=length(strain), batches=paste(batch,collapse=", ")) %>%
    data.frame() %>%
    filter(!duplicated(strain),n>2)

    group_by(Metabolomics_normalized_data,batch,biological) %>%
    filter(!duplicated(strain)) %>%
    select(batch,strain,strain_type) %>%
    group_by(batch) %>%
    summarise(n=length(strain),strains=paste(unique(strain_type),collapse=", "))

    
################################################################################
###Variation in metabolite levels ##############################################
    
    
    data.plot <- filter(Metabolomics_normalized_data,trait_transformation=="Perc.zscore", !is.na(value)) %>%
                 filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                 mutate(strain_type = gsub("PL_","",strain_type)) %>%
                 group_by(strain,metabolite) %>%
                 mutate(value_mean=mean(value,na.rm=T)) %>%
                 filter(!duplicated(strain)) %>%
                 group_by(metabolite) %>%
                 mutate(x_value=rank(value_mean,ties.method="random")) %>%
                 mutate(x_value=x_value/max(x_value)) %>%
                 data.frame()
    
    ###Plot it                 
        p1 <- ggplot(filter(data.plot,Data_type=="Fat"),aes(x=x_value,y=value_mean,colour=strain_type)) +
              geom_point() + geom_point(data=filter(data.plot,Data_type=="Fat",strain_type != "RIL")) + 
              facet_wrap(~metabolite,ncol=8) + presentation + xlab("strain (ranked)") + ylab("z-score") +
              theme(axis.ticks = element_blank(),axis.text.x = element_blank(),legend.position = "none") +
              scale_y_continuous(breaks = c(-4,8), labels = c(-4,8)) +
              colScale
                     
        p2 <- ggplot(filter(data.plot,Data_type=="AA"),aes(x=x_value,y=value_mean,colour=strain_type)) +
              geom_point() + geom_point(data=filter(data.plot,Data_type=="AA",strain_type != "RIL")) + 
              facet_wrap(~metabolite,ncol=8) + presentation + xlab("strain (ranked)") + ylab("z-score") +
              theme(axis.ticks = element_blank(),axis.text.x = element_blank()) +
              scale_y_continuous(breaks = c(-2.5,5), labels = c(-2.5,5)) +
              colScale
    
        ###Blank placeholder
        BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
    
        ###Legend    
        p.legend <- get_legend(p2)
        
        ###re-plot
        p2 <- p2 + theme(legend.position = "none")
        
        postscript("Figure_2-Data_overview.eps",width=7,height=7)
            grid.arrange(p2,BlPl,p1,p.legend,ncol=2,heights = c(1.05,2),widths = c(5,1))   
        dev.off()
        pdf("Figure_2-Data_overview.pdf",width=7,height=7)
            grid.arrange(p2,BlPl,p1,p.legend,ncol=2,heights = c(1.05,2),widths = c(5,1))   
        dev.off()        
        
        
    
################################################################################
###Correlation analysis ########################################################


        cor1 <- filter(Metabolomics_normalized_data,trait_transformation=="Perc.zscore") %>%
                filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%         
                select(batch,strain,metabolite,biological,value,Data_type) %>%
                rename(metabolite1=metabolite,value1=value,Data_type1=Data_type)
        
        cor2 <- rename(cor1,metabolite2=metabolite1,value2=value1,Data_type2=Data_type1)
        
        Cor.data <- merge(cor1,cor2) %>%
                    filter(!is.na(value1),!is.na(value2)) %>%
                    mutate(value1=as.numeric(as.character(unlist(value1))),value2=as.numeric(as.character(unlist(value2)))) %>%
                    group_by(metabolite1,metabolite2,Data_type1,Data_type2) %>%
                    mutate(correlation_n=sum(!is.na(value1) & !is.na(value2))) %>%
                    filter(correlation_n > 1) %>%
                    summarise(correlation=cor(value1,value2,use="pairwise.complete.obs"),correlation_significance=cor.test(value1,value2)$p.value) %>%
                    data.frame()
        
        #Fatdata <- filter(Cor.data,Data_type1==Data_type2,Data_type1=="Fat") %>%
        #           group_by(metabolite1,metabolite2,Data_type1,Data_type2) %>%
        #           mutate(compare=paste(sort(c(unlist(metabolite1),unlist(metabolite2))),collapse=" ")) %>%
        #           data.frame() %>%
        #           filter(!duplicated(compare)) %>%
        #           filter(metabolite1 != metabolite2) %>%
        #           mutate(Correlation_significance_bonferroni=p.adjust(correlation_significance,method="bonferroni")) %>%
        #           filter(Correlation_significance_bonferroni<0.05) %>%
        #           mutate(direction=sign(correlation))
        
        #write.xlsx(Fatdata,file="test.xlsx")
        
        
    ###Correlation analysis Fatty, I removed the IL batch
        Cor.data <- filter(Metabolomics_normalized_data,Data_type=="Fat",trait_transformation=="Perc.zscore") %>%
                    filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                    select(batch,strain,metabolite,biological,value) %>%
                    spread(key=metabolite,value=value); head(Cor.data)
            rownames(Cor.data) <- paste(Cor.data[,1],Cor.data[,2],Cor.data[,3])


        data.cor <- cor(data.matrix(Cor.data[,-c(1:3)]),use="pairwise.complete.obs")
        colscale <- color.scale(colors.use=brewer.pal(11,"RdYlBu"),y.val=as.numeric(data.cor))

        ###Save the figure
        pdf(file="Figure_4B-Correlations_fatty_acids.pdf",width=16,height=8)
            heatmap(data.cor,scale="none",col=colscale,margins=c(10,8))
            par(fig=c(0,0.2,0.6,1),new=T)
            scale.legend(input=as.numeric(data.cor),start.zero=F,col.scale=colscale,line.col="black")
        dev.off()

        postscript(file="Figure_4B-Correlations_fatty_acids.eps",width=16,height=8)
            heatmap(data.cor,scale="none",col=colscale,margins=c(10,8))
            par(fig=c(0,0.2,0.6,1),new=T)
            scale.legend(input=as.numeric(data.cor),start.zero=F,col.scale=colscale,line.col="black")
        dev.off()
                
        pdf(file="Figure_3D-Example_C20.1_C21.1.pdf",width=3,height=3)
            plot.data <- mutate(Metabolomics_normalized_data,metabolite=gsub(":",".",metabolite)) %>%
                         filter(metabolite%in%c("C20.1","C21.1"),trait_transformation=="Perc.zscore") %>%
                         filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                         select(batch,strain,metabolite,biological,value) %>%
                         spread(key=metabolite,value=value)

            R2 <- round(summary(lm(C20.1~C21.1,data=plot.data))$r.squared,digits=2)

            ggplot(plot.data,aes(x=C20.1,y=C21.1,alpha=0.2)) +
            geom_point(colour=brewer.pal(9,"Set1")[9]) + geom_smooth(method="lm",colour="black") +
            geom_text(aes(x=2.5,y=-1.8,label=paste("R2 = ", R2,sep=""))) +
            presentation + ylab("C21:1") + xlab("C20:1") + theme(legend.position = "none")
        dev.off()

        pdf(file="Figure_3D-Example_18.3_17.0.pdf",width=3,height=3)
            plot.data <- mutate(Metabolomics_normalized_data,metabolite=gsub(":",".",metabolite)) %>%
                         filter(metabolite%in%c("C18.3","C17.0"),trait_transformation=="Perc.zscore") %>%
                         filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                         select(batch,strain,metabolite,biological,value) %>%
                         spread(key=metabolite,value=value)

            R2 <- round(summary(lm(C18.3~C17.0,data=plot.data))$r.squared,digits=2)

            ggplot(plot.data,aes(x=C18.3,y=C17.0,alpha=0.2)) +
            geom_point(colour=brewer.pal(9,"Set1")[9]) + geom_smooth(method="lm",colour="black") +
            geom_text(aes(x=-2.5,y=-2.3,label=paste("R2 = ", R2,sep=""))) +
            presentation + ylab("17:0") + xlab("C18:3") + theme(legend.position = "none")
        dev.off()



    ###Correlation analysis AA
        Cor.data <- filter(Metabolomics_normalized_data,Data_type=="AA",trait_transformation=="Perc.zscore") %>%
                    filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>% 
                    select(batch,strain,metabolite,biological,value) %>%
                    spread(key=metabolite,value=value); head(Cor.data)
            rownames(Cor.data) <- paste(Cor.data[,1],Cor.data[,2],Cor.data[,3])


        data.cor <- cor(data.matrix(Cor.data[,-c(1:3)]),use="pairwise.complete.obs")
        colscale <- color.scale(colors.use=brewer.pal(11,"RdYlBu"),y.val=as.numeric(data.cor))

        ###Save the figure
        pdf(file="Figure_4A-Correlations_amino_acids.pdf",width=16,height=8)
            heatmap(data.cor,scale="none",col=colscale,margins=c(10,8))
            par(fig=c(0,0.2,0.6,1),new=T)
            scale.legend(input=as.numeric(data.cor),start.zero=F,col.scale=colscale,line.col="black")
        dev.off()
        
        postscript(file="Figure_4A-Correlations_amino_acids.eps",width=16,height=8)
            heatmap(data.cor,scale="none",col=colscale,margins=c(10,8))
            par(fig=c(0,0.2,0.6,1),new=T)
            scale.legend(input=as.numeric(data.cor),start.zero=F,col.scale=colscale,line.col="black")
        dev.off()

        ###Example Orn and arg        
            plot.data <- filter(Metabolomics_normalized_data,metabolite%in%c("Orn","Arg"),trait_transformation=="Perc.zscore") %>%
                         filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                         select(batch,strain,metabolite,biological,value) %>%
                         spread(key=metabolite,value=value)

            R2 <- round(summary(lm(Orn~Arg,data=plot.data))$r.squared,digits=2)
        
            plot.nu <- ggplot(plot.data,aes(x=Orn,y=Arg,alpha=0.2)) +
                       geom_point(colour=brewer.pal(9,"Set1")[9]) + geom_smooth(method="lm",colour="black") +
                       geom_text(aes(x=-1,y=-4,label=paste("R2 = ", R2,sep=""))) +
                       presentation + ylab("Arg") + xlab("Orn") + theme(legend.position = "none")
            
            pdf(file="Figure_3C-Example_Orn_Arg.pdf",width=3,height=3); plot.nu; dev.off()
            postscript(file="Figure_3C-Example_Orn_Arg.eps",width=3,height=3); plot.nu; dev.off()
            
        ###Example Lysine and Serine
            plot.data <- filter(Metabolomics_normalized_data,metabolite%in%c("Lys","Ser"),trait_transformation=="Perc.zscore") %>%
                         filter(strain_type %in% c("PL_CB4856","PL_N2","RIL")) %>%
                         select(batch,strain,metabolite,biological,value) %>%
                         spread(key=metabolite,value=value)

            R2 <- round(summary(lm(Lys~Ser,data=plot.data))$r.squared,digits=2)
            
            plot.nu <- ggplot(plot.data,aes(x=Lys,y=Ser,alpha=0.2)) +
                       geom_point(colour=brewer.pal(9,"Set1")[9]) + geom_smooth(method="lm",colour="black") +
                       geom_text(aes(x=2.5,y=-1.5,label=paste("R2 = ", R2,sep=""))) +
                       presentation + ylab("Ser") + xlab("Lys") + theme(legend.position = "none")
         
            pdf(file="Figure_3C-Example_Lys_Ser.pdf",width=3,height=3); plot.nu; dev.off()
            postscript(file="Figure_3C-Example_Lys_Ser.eps",width=3,height=3); plot.nu; dev.off()


################################################################################
###Calculate transgression & heritability ######################################
    
        ###Transgression
            data.input <- filter(Metabolomics_normalized_data, !is.na(value),trait_transformation=="Perc.zscore") %>%
                          filter(strain_type %in% c("PL_CB4856","PL_N2","RIL"))
        
            transgression <- transgression.calc(trait.value=data.input$value,strain=data.input$strain,trait=data.input$metabolite,parental.strain=c("N2","CB4856"))
            
            transgression <- mutate(transgression,significant=ifelse(n_strains_transgression>FDR0.05,"Yes","No"))
            
            write.xlsx(transgression,file="Supplementary_file_3-Transgression.xlsx")
            save(transgression,file=paste(workwd,"/QTL/obj_transgression.Rdata",sep=""))
        
        ###Heritability
            data.input <- filter(Metabolomics_normalized_data, !is.na(value),trait_transformation=="Perc.zscore",strain_type %in% c("RIL")) %>%
                          group_by(strain,metabolite,Data_type) %>%
                          mutate(n=length(metabolite)) %>%
                          as.data.frame() %>%
                          filter(n>3) %>%
                          group_by(metabolite) %>%
                          mutate(n_obs=length(strain)) %>%
                          as.data.frame() %>%
                          filter(n_obs>100)

            heritability <- H2.broad(trait.value=data.input$value,strain=data.input$strain,trait=data.input$metabolite)

            
            
       ###Plot heritability
            data.plot <- merge(heritability,filter(data.input[,c(1,2,13)],!duplicated(metabolite)),by.x=1,by.y=1)
            
            write.xlsx(data.plot,file="Supplementary_file_4-Heritability.xlsx")
            heritability <- data.plot; save(heritability,file=paste(workwd,"/QTL/obj_heritability.Rdata",sep=""))
            
            p1 <- ggplot(filter(data.plot,Data_type=="AA"),aes(x=metabolite_fullname,y=H2_ANOVA)) +
                  geom_bar(stat="identity") + geom_hline(yintercept=0.32,linetype=2,size=1) +
                  theme(axis.text.x = element_text(angle = 45, hjust = 1)) + presentation +
                  xlab("Amino acid") + ylab("Heritability") + geom_text(aes(x=3,y=0.27,label="FDR = 0.05"))
            
            p2 <- ggplot(filter(data.plot,Data_type=="Fat"),aes(x=metabolite_fullname,y=H2_ANOVA)) +
                  geom_bar(stat="identity") + geom_hline(yintercept=0.32,linetype=2,size=1) +
                  theme(axis.text.x = element_text(angle = 45, hjust = 1)) + presentation +
                  xlab("Fatty acid") + ylab("Heritability") + geom_text(aes(x=3,y=0.27,label="FDR = 0.05"))
                
            ###Blank placeholder
            BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
             
            ###layout
            layout_matrix <- rbind(c(1,2),c(3,3))
            
            plot.nu <- grid.arrange(p1,BlPl,p2,widths=c(1.32,1),layout_matrix=layout_matrix)
                          
            pdf(file="Figure_4-Heritability.pdf",width=6,height=6); plot.nu; dev.off()
            postscript(file="Figure_4-Heritability.eps",width=6,height=6); plot.nu; dev.off()
            
            
        ###Heritability, parental lines
           data.input <- filter(Metabolomics_normalized_data, !is.na(value),trait_transformation=="Perc.zscore",strain_type %in% c("PL_N2","PL_CB4856")) %>%
                          group_by(strain,metabolite,Data_type) %>%
                          mutate(n=length(metabolite)) %>%
                          as.data.frame() %>%
                          filter(n>3) %>%
                          group_by(metabolite) %>%
                          mutate(n_obs=length(strain)) %>%
                          as.data.frame() %>%
                          filter(n_obs>6)

           heritability.parental <- H2.broad(trait.value=data.input$value,strain=data.input$strain,trait=data.input$metabolite,Vg.factor = 0.5)

        ###Plot it        
            myColors <- c(brewer.pal(9,"Set1")[1:4])
            
            names(myColors) <- c("Not significant","Broad-sense","Parental","Parental +\nBroad-sense")
            
            
            herScale <- scale_colour_manual(name = "significance",values = myColors)
            fillherScale <- scale_fill_manual(name = "significance",values = myColors)
            

            data.plot <- rename(heritability.parental,H2_ANOVA_PL=H2_ANOVA,Vg_PL=Vg,Ve_PL=Ve,FDR0.05_ANOVA_PL=FDR0.05_ANOVA) %>%
                         merge(heritability) %>%
                         mutate(significance=ifelse(H2_ANOVA_PL>FDR0.05_ANOVA_PL & H2_ANOVA>FDR0.05_ANOVA,"Parental +\nBroad-sense",
                                               ifelse(H2_ANOVA_PL<FDR0.05_ANOVA_PL & H2_ANOVA>FDR0.05_ANOVA,"Broad-sense",
                                                 ifelse(H2_ANOVA_PL>FDR0.05_ANOVA_PL & H2_ANOVA<FDR0.05_ANOVA,"Parental",
                                                   ifelse(H2_ANOVA_PL<FDR0.05_ANOVA_PL & H2_ANOVA<FDR0.05_ANOVA,"Not significant",NA))))) %>%
                         merge(filter(data.input[,c(1,2,13)],!duplicated(metabolite)),by.x=1,by.y=1)
           
            heritability.parental <- data.plot; save(heritability.parental,file=paste(workwd,"/QTL/obj_heritability.parental.Rdata",sep=""))
            
            write.xlsx(data.plot,file="Supplementary_file_4-Heritability_parental.xlsx")
           
            p1 <- ggplot(filter(data.plot,Data_type=="AA"),aes(x=H2_ANOVA_PL,y=H2_ANOVA,colour=significance)) +
                  geom_point() + geom_abline(intercept=0,slope=1,linetype=2,size=1) +
                  presentation + xlim(0,1) + ylim(0,1) + facet_grid(.~Data_type) + herScale +
                  xlab("Parental heritabilty") + ylab("Broad-sense heritability")
            
            p2 <- ggplot(filter(data.plot,Data_type=="Fat"),aes(x=H2_ANOVA_PL,y=H2_ANOVA,colour=significance)) +
                  geom_point() + geom_abline(intercept=0,slope=1,linetype=2,size=1) +
                  presentation + xlim(0,1) + ylim(0,1) + facet_grid(.~Data_type) + herScale +
                  xlab("Parental heritabilty") + ylab("Broad-sense heritability")
            
            p.legend <- get_legend(p2)
            
            p1 <- p1+theme(legend.position = "none")
            p2 <- p2+theme(legend.position = "none")
            
            pdf(file="Supplementary_file_5-h2_versus_H2.pdf",width=7,height=2.5); grid.arrange(p1,p2,p.legend,nrow=1,widths=c(3,3,1.5)); dev.off()
            postscript(file="Supplementary_file_5-h2_versus_H2.eps",width=7,height=2.5); grid.arrange(p1,p2,p.legend,nrow=1,widths=c(3,3,1.5)); dev.off()

################################################################################
###QTL mapping using a single marker model #####################################
            
    QTL.data <- filter(Metabolomics_normalized_data, !is.na(value),strain_type %in% c("RIL")) %>%
                group_by(strain,metabolite,Data_type,trait_transformation) %>%
                summarise(value=mean(value,na.rm=T)) %>%
                data.frame() %>%
                filter(trait_transformation=="Perc.zscore") %>%
                select(trait_transformation,metabolite,strain,value) %>%
                spread(key=strain,value=value) %>%
                as.data.frame()
        rownames(QTL.data) <- apply(QTL.data[,1:2],1,paste,collapse="_")            
        QTL.data <- data.matrix(QTL.data[,-c(1:2)]) 
        
    ###Check how many strains have a value
        table(apply(!is.na(QTL.data),1,sum))
        
        QTL.data <- QTL.data[apply(!is.na(QTL.data),1,sum)>50,]
        rownames(QTL.data)

        
    ###QTL mapping & permutation
        QTL.data <- QTL.data.prep(QTL.data,strain.trait=colnames(QTL.data),strain.map=popmap,strain.marker=popmrk)
        
        met.QTL <- map.1(trait.matrix=QTL.data[[1]],strain.map=QTL.data[[2]],strain.marker=QTL.data[[3]])
        save(met.QTL,file=paste(workwd,"/QTL/obj_met.QTL.Rdata",sep=""))
    
        for(i in 1:100){
            met.QTL.perm <- map.1.perm(trait.matrix=QTL.data[[1]],strain.map=QTL.data[[2]],strain.marker=QTL.data[[3]],1)
            save(met.QTL.perm,file=paste(workwd,"/QTL/FDR/obj_met.QTL.perm",i,".Rdata",sep=""))
        }
        
        filenames.perm <- dir(paste(workwd,"/QTL/FDR",sep=""))
        met.FDR <- map.perm.fdr(map1.output = met.QTL,filenames.perm = filenames.perm,FDR_dir = paste(workwd,"/QTL/FDR/",sep=""),q.value=0.05)
        met.FDR[[1]]
       
        save(met.FDR,file=paste(workwd,"/QTL/obj_met.FDR.Rdata",sep="")) 

                
################################################################################
###QTL mapping using a multi marker model ######################################

    QTL.data <- filter(Metabolomics_normalized_data, !is.na(value),strain_type %in% c("RIL")) %>%
                group_by(strain,metabolite,Data_type,trait_transformation) %>%
                summarise(value=mean(value,na.rm=T)) %>%
                data.frame() %>%
                filter(trait_transformation=="Perc.zscore") %>%
                select(trait_transformation,metabolite,strain,value) %>%
                spread(key=strain,value=value) %>%
                as.data.frame()
        rownames(QTL.data) <- apply(QTL.data[,1:2],1,paste,collapse="_")            
        QTL.data <- data.matrix(QTL.data[,-c(1:2)]) 
        
    ###Check how many strains have a value
        table(apply(!is.na(QTL.data),1,sum))
        
        QTL.data <- QTL.data[apply(!is.na(QTL.data),1,sum)>50,]
        rownames(QTL.data)

        
    ###QTL mapping & permutation
        QTL.data <- QTL.data.prep(QTL.data,strain.trait=colnames(QTL.data),strain.map=popmap,strain.marker=popmrk)
        
        
        met.QTL.add <- map.2(trait.matrix=QTL.data[[1]],strain.map=QTL.data[[2]],strain.marker=QTL.data[[3]],method="Additive")
        met.QTL.int <- map.2(trait.matrix=QTL.data[[1]],strain.map=QTL.data[[2]],strain.marker=QTL.data[[3]],method="Interaction")
        
        save(met.QTL.add,file=paste(workwd,"/QTL/obj_met.QTL.add.Rdata",sep=""))
        save(met.QTL.int,file=paste(workwd,"/QTL/obj_met.QTL.int.Rdata",sep=""))
 
        
    
################################################################################
###power analyis ###############################################################
      
    ###Load QTL data
        load(file=paste(workwd,"/QTL/obj_met.QTL.Rdata",sep=""))
          
        mQTL.simulation <- map.1.simulation(strain.map=met.QTL$Map,strain.marker=met.QTL$Marker,threshold=3.7,sigma_peak = c(0.46,0.67,0.84,1,1.15,1.3,1.47,1.64,1.82,2,2.2,2.47,2.73,3.05,3.45,4))

    ###Check outcome
        filter(mQTL.simulation,Simulation.var_explained==0.10) %>%
        select(QTL_detection.detected_true:QTL_detection.percentage_false)

    
################################################################################
###QTL analysis ################################################################
        
    ###Load data     
        load(file=paste(workwd,"/QTL/obj_met.QTL.Rdata",sep=""))
        load(file=paste(workwd,"/QTL/obj_heritability.parental.Rdata",sep=""))        
                
    ###Peak calling
        met.peak.QTL <- mapping.to.list(map1.output=met.QTL) %>%
                        peak.finder(threshold=3.7)
    
    ###Make QTL table
        met.table.QTL <- filter(met.peak.QTL,!is.na(qtl_peak)) %>%
                         eQTL.table.addR2(met.QTL) %>%
                         separate(trait,into=c("transformation","metabolite"),sep="_") %>%
                         mutate(measurement="") %>%
                         group_by(metabolite,qtl_chromosome,qtl_marker,transformation) %>%
                         mutate(measurement=ifelse(grepl(":",metabolite),"Fatty acid","Amino acid")) %>%
                         data.frame() %>%
                         merge(select(heritability.parental,trait,metabolite_fullname,H2_ANOVA_PL,H2_ANOVA),by.x=2,by.y=1) %>%
                         mutate(trait=paste(transformation,metabolite,sep="_"))
        
        save(met.table.QTL,file=paste(workwd,"/QTL/obj_met.table.QTL.Rdata",sep=""))
        
        write.xlsx(met.table.QTL,file="Supplementary_file_7-mQTL_table.xlsx")
        
        
    ###MQM
        met.multipeak <- map.1.interactions(met.table.QTL,met.QTL)
        
        save(met.multipeak,file=paste(workwd,"/QTL/obj_met.multipeak.Rdata",sep=""))
           
        met.xlsx <- mutate(met.multipeak,trait=gsub("Perc.zscore_","",trait)) %>%
                    rename(metabolite=trait) %>%
                    select(-p_val) 
        
        write.xlsx(met.xlsx,file="Supplementary_file_x-interactions.xlsx")

    ###Make plot       
        data.plot <- mutate(met.table.QTL,gene_chromosome="I",gene_bp=1000,trait=metabolite,qtl_type="trans") %>%
                     prep.ggplot.eQTL.table() %>%
                     mutate(metabolite_fullname=ifelse(measurement=="","Alanine",as.character(unlist(metabolite_fullname))),
                            qtl_significance=ifelse(measurement=="",NA,qtl_significance),
                            measurement=ifelse(measurement=="","Amino acid",measurement))
        
        plot.nu <- ggplot(data.plot,aes(x=qtl_bp,y=metabolite_fullname,colour=qtl_significance)) +
                   geom_point() + geom_segment(aes(x=qtl_bp_left,xend=qtl_bp_right,y=metabolite_fullname,yend=metabolite_fullname)) +
                   facet_grid(measurement~qtl_chromosome,scales="free",space="free") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu"),na.value=NA,name="Significance\n(-log10(P))") +
                   presentation + scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("mQTL location (Mbp)") + ylab("Metabolite")

        
        pdf(file="Figure_5-mQTL.pdf",width=7,height=4); plot.nu; dev.off()
        postscript(file="Figure_5-mQTL.eps",width=7,height=4); plot.nu; dev.off()
    

################################################################################
###MQM analysis ################################################################
        
    ###Load data
        load(file=paste(workwd,"/QTL/obj_met.QTL.add.Rdata",sep=""))
        load(file=paste(workwd,"/QTL/obj_met.QTL.int.Rdata",sep=""))
        

    ###Check interaction model
        met.int <- data.frame(cbind(metabolite=1:nrow(met.QTL.int$Interaction),met.QTL.int$Interaction)) %>%
                   filter(!is.na(pvali),pvali > 1.3) %>%
                   merge(cbind(marker_1=1:nrow(met.QTL.int$Marker),chromosome_1=met.QTL.int$Marker[,2])) %>%
                   merge(cbind(marker_2=1:nrow(met.QTL.int$Marker),chromosome_2=met.QTL.int$Marker[,2])) %>%
                   filter(marker_1-marker_2 >50 | chromosome_1 != chromosome_2) %>%
                   mutate(metabolite=rownames(met.QTL.int$Interaction)[metabolite]) %>%
                   mutate(metabolite=gsub("Perc.zscore_","",metabolite)) %>%
                   group_by(metabolite) %>%
                   mutate(pval_FDR=p.adjust(10^-pvali,method="BH",n=(0.5*729*729-6*120*120))) %>%
                   data.frame() %>%
                   arrange(pval_FDR) %>%
                   group_by(metabolite,chromosome_1,chromosome_2) %>%
                   filter(pvali==max(pvali)) %>%
                   mutate(marker_2_range=paste(min(marker_2),max(marker_2),sep=":"),marker_1_range=paste(min(marker_1),max(marker_1),sep=":")) %>%
                   filter(!duplicated(marker_2_range)) %>%
                   group_by(metabolite) %>%
                   filter(!duplicated(effi)) %>%
                   data.frame() %>%
                   filter(pval_FDR < 0.1)
        
        save(met.int,file=paste(workwd,"/QTL/obj_met.int.Rdata",sep=""))
        
        write.xlsx(met.int,file="Supplementary_file_x-2D_scan.xlsx")
        
        

################################################################################
###transgression, heritability and mQTL ########################################
        
    ###Load stuff
        load(file=paste(workwd,"/QTL/obj_met.QTL.Rdata",sep=""))    
        load(file=paste(workwd,"/QTL/obj_met.int.Rdata",sep=""))    
        load(file=paste(workwd,"/QTL/obj_met.multipeak.Rdata",sep=""))
        load(file=paste(workwd,"/QTL/obj_met.table.QTL.Rdata",sep=""))
        load(file=paste(workwd,"/QTL/obj_heritability.parental.Rdata",sep=""))        
        load(file=paste(workwd,"/QTL/obj_transgression.Rdata",sep=""))
        
        ###Prep additive
            met.table.additive <- group_by(met.multipeak,model,trait) %>%
                                  filter(!duplicated(markers)) %>%
                                  mutate(n=length(markers),eff_sum_abs=sum(abs(effect)),eff_sum=sum(effect)) %>%
                                  data.frame() %>%
                                  filter(model=="additive",!duplicated(trait)) %>%
                                  mutate(trait=gsub("Perc.zscore_","",trait)) %>%
                                  filter(!trait %in% c("C15:1","C16:1","C24:5","Gln","Ala","Asp"))
        
            met.table.single <- filter(met.table.QTL,!metabolite %in% c(met.table.additive$trait,"C15:1","C16:1","C24:5","Gln","Ala","Asp"))
            
        ###Prep interaction
            met.table.interaction <- NULL
            ###15:1
                trait <- "C15:1"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[116,]+map[575,]:map[514,])); tmp.lm
                tmp <- anova(lm(select~map[116,]+map[575,]:map[514,])); tmp
                tmp <- tmp[[2]]
                
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=tmp[1]/sum(tmp),var_explained_interaction=tmp[2]/sum(tmp),
                                                                           n=3,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
        
            
            ##16:1
                trait <- "C16:1"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[611,]:map[107,]+map[447,]:map[92,]+map[637,]:map[196,]+map[541,]:map[61,]+map[673,]:map[554,]+map[445,]:map[198,]+map[328,]:map[262,]+map[162,]:map[17,]+map[688,]:map[234,])); tmp.lm
                tmp <- anova(lm(select~map[611,]:map[107,]+map[447,]:map[92,]+map[637,]:map[196,]+map[541,]:map[61,]+map[673,]:map[554,]+map[445,]:map[198,]+map[328,]:map[262,]+map[162,]:map[17,]+map[688,]:map[234,])); tmp
                tmp <- tmp[[2]]
                                
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=0,var_explained_interaction=sum(tmp[-length(tmp)])/sum(tmp),
                                                                           n=16,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
        
                
            ##24:5
                trait <- "C24:5"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[91,]+map[451,]:map[389,]+map[144,]:map[107,])); tmp.lm
                tmp <- anova(lm(select~map[91,]+map[451,]:map[389,]+map[144,]:map[107,])); tmp
                tmp <- tmp[[2]]
                
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=tmp[1]/sum(tmp),var_explained_interaction=sum(tmp[2:3])/sum(tmp),
                                                                           n=5,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
                    

            ##Glutamine
                trait <- "Gln"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[530,]+map[641,]+map[723,]:map[368,]+map[451,]:map[118,])); tmp.lm
                tmp <- anova(lm(select~map[530,]+map[641,]+map[723,]:map[368,]+map[451,]:map[118,])); tmp
                tmp <- tmp[[2]]
                
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=sum(tmp[1:2])/sum(tmp),var_explained_interaction=sum(tmp[3:4])/sum(tmp),
                                                                           n=6,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
                
                                   
            ##Alanine
                trait <- "Ala"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[534,]+map[480,]:map[201,]+map[721,]:map[229,])); tmp.lm
                tmp <- anova(lm(select~map[534,]+map[480,]:map[201,]+map[721,]:map[229,])); tmp
                tmp <- tmp[[2]]
                               
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=sum(tmp[1])/sum(tmp),var_explained_interaction=sum(tmp[2:3])/sum(tmp),
                                                                           n=5,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
                                    
                
            ##Aspartic acid
                trait <- "Asp"
                select <- met.QTL$Trait[rownames(met.QTL$Trait)==paste("Perc.zscore_",trait,sep=""),]
                map <- met.QTL$Map
                
                tmp.lm <- summary(lm(select~map[511,]:map[144,])); tmp.lm
                tmp <- anova(lm(select~map[511,]:map[144,])); tmp
                tmp <- tmp[[2]]
                                
                met.table.interaction <- rbind(met.table.interaction,cbind(metabolite=trait,model_type="interaction",markers="multiple",
                                                                           var_explained_additive=0,var_explained_interaction=tmp[1]/sum(tmp),
                                                                           n=2,eff_sum_abs=sum(abs(tmp.lm[[4]][-1,1])),eff_sum=sum(tmp.lm[[4]][-1,1])))
            
                                        
                
        met.table.rsq <- rbind(met.table.interaction,                
                               cbind(metabolite=met.table.additive$trait,model_type="additive_multiple",markers="multiple",
                                     var_explained_additive=met.table.additive$Rsquared, var_explained_interaction=0, 
                                     n=met.table.additive$n,eff_sum_abs=met.table.additive$eff_sum_abs,eff_sum=met.table.additive$eff_sum),
                               cbind(metabolite=met.table.single$metabolite,model_type="additive_single",markers="single",
                                     var_explained_additive=met.table.single$qtl_R2_sm, var_explained_interaction=0, 
                                     n=1,eff_sum_abs=abs(met.table.single$qtl_effect),eff_sum=met.table.single$qtl_effect))
        met.table.rsq <- data.frame(met.table.rsq)
            met.table.rsq[,1] <- as.character(unlist(met.table.rsq[,1]))
            met.table.rsq[,2] <- as.character(unlist(met.table.rsq[,2]))
            met.table.rsq[,3] <- as.character(unlist(met.table.rsq[,3]))
            met.table.rsq[,4] <- as.numeric(as.character(unlist(met.table.rsq[,4])))
            met.table.rsq[,5] <- as.numeric(as.character(unlist(met.table.rsq[,5])))
            met.table.rsq[,6] <- as.numeric(as.character(unlist(met.table.rsq[,6])))
            met.table.rsq[,7] <- as.numeric(as.character(unlist(met.table.rsq[,7])))
            met.table.rsq[,8] <- as.numeric(as.character(unlist(met.table.rsq[,8])))
            
        met.table.rsq <- merge(met.table.rsq,heritability.parental,by.x=1,by.y=1,all.y=TRUE) %>%
                         merge(rename(select(transgression,trait,significant,n_strains_transgression),transgression=significant),by.x=1,by.y=1) %>%
                         mutate(model_type=ifelse(is.na(var_explained_additive) & is.na(var_explained_interaction),"none",model_type),
                                n=ifelse(is.na(var_explained_additive) & is.na(var_explained_interaction),0,n),
                                eff_netto=abs(eff_sum)) %>%
                         mutate(var_explained_additive=ifelse(is.na(var_explained_additive),0,var_explained_additive),
                                var_explained_interaction=ifelse(is.na(var_explained_interaction),0,var_explained_interaction))
            
        data.plot <- mutate(met.table.rsq,transgression=ifelse(transgression=="No","",",t"))

        
        anova(lm(H2_ANOVA~n_strains_transgression,data=data.plot))
        anova(lm(H2_ANOVA_PL~n_strains_transgression,data=data.plot))

        anova(lm(H2_ANOVA~(var_explained_interaction:var_explained_additive),data=data.plot))
        anova(lm(H2_ANOVA_PL~(var_explained_interaction:var_explained_additive),data=data.plot))

        anova(lm(n_strains_transgression~(var_explained_interaction:var_explained_additive),data=data.plot))
                
        p1 <- ggplot(data.plot,aes(x=H2_ANOVA,y=n_strains_transgression,colour=n)) + 
              geom_point() + presentation + geom_text(aes(label=paste(transgression,sep=""),vjust="bottom",hjust="left")) + 
              xlab("Heritability") + ylab("transgressing strains (n)") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu")[-c(5:7)],na.value=NA,name="mQTL (n)") +
              theme(legend.position = "none") + geom_vline(xintercept=0.32,linetype=2,size=1)
        
        p2 <- ggplot(data.plot,aes(x=H2_ANOVA,y=var_explained_interaction+var_explained_additive,colour=n)) + 
              geom_point() + presentation + geom_text(aes(label=paste(transgression,sep=""),vjust="bottom",hjust="left")) + 
              xlab("Heritability") + ylab("Variation\nexplained by mQTL") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu")[-c(5:7)],na.value=NA,name="mQTL (n)") +
              theme(legend.position = "none") + geom_vline(xintercept=0.32,linetype=2,size=1)
        
        p3 <- ggplot(data.plot,aes(x=n_strains_transgression,y=var_explained_interaction+var_explained_additive,colour=n)) + 
              geom_point() + presentation + geom_text(aes(label=paste(transgression,sep=""),vjust="bottom",hjust="left")) + 
              xlab("transgressing strains (n)") + ylab("Variation\nexplained by mQTL") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu")[-c(5:7)],na.value=NA,name="mQTL (n)")
        
        p4 <- ggplot(data.plot,aes(x=H2_ANOVA_PL,y=n_strains_transgression,colour=n)) + 
              geom_point() + presentation + geom_text(aes(label=paste(transgression,sep=""),vjust="bottom",hjust="left")) + 
              xlab("Parental heritability") + ylab("transgressing strains (n)") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu")[-c(5:7)],na.value=NA,name="mQTL (n)") +
              theme(legend.position = "none") + geom_vline(xintercept=0.19,linetype=2,size=1)
        
        p5 <- ggplot(data.plot,aes(x=H2_ANOVA_PL,y=var_explained_interaction+var_explained_additive,colour=n)) + 
              geom_point() + presentation + geom_text(aes(label=paste(transgression,sep=""),vjust="bottom",hjust="left")) + 
              xlab("Parental heritability") + ylab("Variation\nexplained by mQTL") + scale_colour_gradientn(colours=brewer.pal(11,"RdYlBu")[-c(5:7)],na.value=NA,name="mQTL (n)") +
              theme(legend.position = "none") + geom_vline(xintercept=0.19,linetype=2,size=1)
        

        BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
            BlPl1 <- ggplot()+geom_blank(aes(1,1))+ blank_theme
            BlPl2 <- ggplot()+geom_blank(aes(1,1))+ blank_theme
        
        ###layout
        layout_matrix <- rbind(c(rep(1,3),rep(2,97),rep(3,3),rep(4,97)),c(rep(5,100),rep(6,100)),c(rep(7,128),rep(8,72)))        
              
        annotation.grobA <- title.grob <- textGrob(label = "A",x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
        annotation.grobB <- title.grob <- textGrob(label = "B",x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
        annotation.grobC <- title.grob <- textGrob(label = "C",x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
        annotation.grobD <- title.grob <- textGrob(label = "D",x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
        annotation.grobE <- title.grob <- textGrob(label = "E",x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))

        p1 <- arrangeGrob(p1,top=annotation.grobA)
        p4 <- arrangeGrob(p4,top=annotation.grobB)
        p2 <- arrangeGrob(p2,top=annotation.grobC)
        p5 <- arrangeGrob(p5,top=annotation.grobD)
        p3 <- arrangeGrob(p3,top=annotation.grobE)

          
        pdf(file="Supplementary_file_x-transgression_heritability_mQTL_v2.pdf",width=6,height=8); grid.arrange(BlPl1,p1,BlPl2,p4,p2,p5,p3,layout_matrix=layout_matrix); dev.off()
        postscript(file="Supplementary_file_x-transgression_heritability_mQTL.eps",width=6,height=2.5); grid.arrange(BlPl1,p1,BlPl2,p4,p2,p5,p3,layout_matrix=layout_matrix); dev.off()
             
        
        ####Plot it
        myColors <- c(brewer.pal(9,"Set1")[c(2,3,1)])
        
        names(myColors) <- c("Residual","additive\nmQTL","interaction\nmQTL")
        
        
        herScale <- scale_colour_manual(name = "Variation\nexplained",values = myColors)
        fillherScale <- scale_fill_manual(name = "Variation\nexplained",values = myColors)
                
        data.plot <- mutate(met.table.rsq,var_explained_additive=ifelse(is.na(var_explained_additive),0,var_explained_additive),
                                          var_explained_interaction=ifelse(is.na(var_explained_interaction),0,var_explained_interaction)) %>%
                     mutate(var_residual=H2_ANOVA-(var_explained_additive+var_explained_interaction)) %>%
                     arrange(-H2_ANOVA) %>%
                     mutate(metabolite=factor(metabolite,levels=unique(metabolite))) %>%
                     select(metabolite,model_type,var_explained_additive,var_explained_interaction,var_residual,Data_type) %>%
                     gather(key=variation,value=fraction,-metabolite,-model_type,-Data_type) %>%
                     mutate(variation = ifelse(variation=="var_residual","Residual",
                                          ifelse(variation=="var_explained_additive","additive\nmQTL","interaction\nmQTL"))) %>%
                     mutate(variation=factor(variation,levels=c("interaction\nmQTL","additive\nmQTL","Residual")))
        
        p1 <- ggplot(filter(data.plot,Data_type=="AA"),aes(x=metabolite,y=fraction,fill=variation)) +
              geom_bar(stat="identity") + theme(axis.text.x = element_text(angle = 45, hjust = 1)) + presentation +
              xlab("Amino acid") + ylab("Heritability") + fillherScale
        
        p2 <- ggplot(filter(data.plot,Data_type=="Fat"),aes(x=metabolite,y=fraction,fill=variation)) +
              geom_bar(stat="identity") + presentation +
              theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + xlab("Fatty acid") + ylab("Heritability") + fillherScale
        
        ###Blank placeholder
        BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
        
        ###layout
        layout_matrix <- rbind(c(1,2),c(3,3))
    
        
        pdf(file="Figure_5C-Heritability_var_explained.pdf",width=6,height=6); grid.arrange(p1,BlPl,p2,widths=c(3.74,1),layout_matrix=layout_matrix); dev.off()
        postscript(file="Figure_5C-Heritability_var_explained.eps",width=6,height=6); grid.arrange(p1,BlPl,p2,widths=c(3.74,1),layout_matrix=layout_matrix); dev.off()
        
        
################################################################################
###IL analysis C14:1 ###########################################################

    ###Plot QTL profile and genosplit
        data.test <- prep.ggplot.QTL.profile(QTL.peak.output = met.peak.QTL, map1.output = met.QTL,trait="Perc.zscore_C14:1")
        
        data.plot <- data.test[[1]]
        
        p1 <- ggplot(data.plot,aes(x=qtl_bp,y=qtl_significance)) +
              geom_line(size=2) + facet_grid(.~qtl_chromosome,scales="free",space="free") + geom_hline(yintercept=3.7,linetype=2,size=1) +
              presentation + scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("mQTL location (Mbp)") + ylab("\nsignificance (-log10(p))")
  
        data.plot <- mutate(data.test[[2]], geno_strain=ifelse(genotype==-1,"CB4856","N2"))
        
        p2 <- ggplot(data.plot,aes(x=geno_strain,y=trait_value)) +
              geom_jitter(height=0,width=0.25,aes(colour=geno_strain),alpha=0.2) + geom_boxplot(outlier.shape=NA,alpha=0.2,aes(fill=geno_strain)) +
              presentation + colScale + fillScale + 
              geom_text(aes(x=1.5,y=max(trait_value,na.rm=T),label=paste("R2 = ",round(R_squared,digits=2),sep=""))) +
              xlab("Genotype at marker") + ylab("C14:1 (z-score)")
       
    ###Plot ILs chromosome I 
        data.plot <- prep.ggplot.genetic.map(strain.map=popmap,strain.marker=popmrk) %>% 
                    filter(tolower(strain) %in% c("n2","cb4856","wn212","wn215","wn217")) %>%
                    rbind(filter(cbnmap,strain %in% c("cbn021","cbn020","cbn019","cbn017","wn218"))) %>%
                    mutate(index=as.numeric(as.factor(strain)),genotype_name=ifelse(genotype==-1,"CB4856",ifelse(genotype==1,"N2",NA))) %>%
                    filter(chromosome != "MtDNA") %>%
                    filter((position_end-position_start)>1e5)
                         
        p3 <- ggplot(data.plot,aes(xmin=position_start,xmax=position_end,ymin=index,ymax=index+1,fill=genotype_name)) +
              geom_rect() + facet_grid(.~chromosome, scales="free", space="free") +
              fillScale + presentation +
              scale_y_continuous(breaks = unique(data.plot$index) + 0.5, labels = unique(data.plot$strain)) +
              scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("Marker location (Mbp)")

    ###Plot genosplit ILs chromosome I
        data.plot <- filter(Metabolomics_normalized_data,strain_type != "RIL",batch == 9) %>%
                    filter(tolower(strain) %in% c("n2","cb4856","wn212","wn215","wn217","wn218","cbn021","cbn020","cbn019","cbn017")) %>%
                    filter(trait_transformation == "Perc.zscore", metabolite == "C14:1") %>%
                    mutate(strain = toupper(strain),gen.back=ifelse(grepl("N2",strain_type),"N2\nbackground","CB4856\nbackground"))
        
        ###Significances
        data.test <- spread(select(data.plot,strain,biological,value),key=strain,value=value)
            test.cbn <- apply(data.test[,3:6],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=data.test[,2],alternative="less")
            test.ewi <- apply(data.test[,8:11],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=data.test[,7],alternative="greater")     
            data.test <- data.frame(cbind(strain=names(c(test.cbn,test.ewi)),significance=c(test.cbn,test.ewi))) %>%
                        mutate(significance=as.numeric(as.character(unlist(significance)))) %>%
                        mutate(p.adjust=p.adjust(significance,method="fdr")) %>%
                        mutate(labs=ifelse(p.adjust>0.05,"NS",ifelse(p.adjust<0.001,"***",ifelse(p.adjust<0.01,"**",ifelse(p.adjust<0.05,"*",NA))))) %>%
                        merge(select(data.plot,strain,gen.back))
           
        p4 <- ggplot(data.plot,aes(x=strain,y=value)) +
              geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
              presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
              geom_text(aes(x=strain,y=2,label=labs,size=3),data=data.test) + 
              facet_grid(.~gen.back,space="free",scales="free") + xlab("Strain") + ylab("C14:1 (z-score)")
                   
        ###Actually plot
            ###Blank placeholder
            BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
           
            ###layout
            layout_matrix <- rbind(c(rep(1,1),rep(1,15),rep(2,6)),c(rep(3,15),rep(4,7)))
            
            ###plot              
            pdf(file="Figure_6-C14.1_mQTL.pdf",width=10,height=6); grid.arrange(p1,p2,p3,p4,layout_matrix=layout_matrix); dev.off()
            postscript(file="Figure_6-C14.1_mQTL.eps",width=10,height=6); grid.arrange(p1,p2,p3,p4,layout_matrix=layout_matrix); dev.off()

            
################################################################################
###IL analysis C18:2 ###########################################################
            
    ###Plot QTL profile and genosplit
        data.test <- prep.ggplot.QTL.profile(QTL.peak.output = met.peak.QTL, map1.output = met.QTL,trait="Perc.zscore_C18:2")
        
        data.plot <- data.test[[1]]
        
        p1 <- ggplot(data.plot,aes(x=qtl_bp,y=qtl_significance)) + geom_hline(yintercept=3.7,linetype=2,size=1) +
              geom_line(size=2) + facet_grid(.~qtl_chromosome,scales="free",space="free") + 
              presentation + scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("mQTL location (Mbp)") + ylab("\nsignificance (-log10(p))")

          
        data.plot <- prep.ggplot.QTL.profile(QTL.peak.output = met.peak.QTL, map1.output = met.QTL,trait="Perc.zscore_C18:2")
        
        data.plot1 <- mutate(data.plot[[2]], geno_strain_II=ifelse(genotype==-1,"CB4856","N2")) %>%
                      select(geno_strain_II,trait_value,strain)
        data.plot2 <- mutate(data.plot[[3]], geno_strain_IV=ifelse(genotype==-1,"CB4856","N2")) %>%
                      select(geno_strain_IV,trait_value,strain)
        data.plot <- merge(data.plot1,data.plot2) %>%
                     mutate(geno_strain = paste(geno_strain_II," (II)\n",geno_strain_IV," (IV)",sep=""),
                            colscheme=ifelse(geno_strain_II=="CB4856" & geno_strain_IV == "CB4856","CB4856",
                                        ifelse(geno_strain_II=="N2" & geno_strain_IV == "N2","N2","RIL")))
            
        p2 <- ggplot(data.plot,aes(x=geno_strain,y=trait_value)) +
            geom_jitter(height=0,width=0.25,aes(colour=colscheme),alpha=0.2) + geom_boxplot(outlier.shape=NA,alpha=0.2,aes(fill=colscheme)) +
            presentation + colScale + fillScale + theme(legend.position = "none",axis.text.x = element_text(angle = 45, hjust = 1)) +
            xlab("Genotype at marker") + ylab("C18:2 (z-score)")
        
        ###Plot ILs chromosome IV 
        data.plot <- prep.ggplot.genetic.map(strain.map=popmap,strain.marker=popmrk) %>% 
            filter(tolower(strain) %in% c("n2","cb4856","wn251","wn252")) %>%
            rbind(filter(cbnmap,strain %in% c("cbn079","cbn080","cbn081","cbn089"))) %>%
            mutate(index=as.numeric(as.factor(strain)),genotype_name=ifelse(genotype==-1,"CB4856",ifelse(genotype==1,"N2",NA))) %>%
            filter(chromosome != "MtDNA") %>%
            filter((position_end-position_start)>1e5)
        
        p3 <- ggplot(data.plot,aes(xmin=position_start,xmax=position_end,ymin=index,ymax=index+1,fill=genotype_name)) +
            geom_rect() + facet_grid(.~chromosome, scales="free", space="free") +
            fillScale + presentation +
            scale_y_continuous(breaks = unique(data.plot$index) + 0.5, labels = unique(data.plot$strain)) +
            scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("Marker location (Mbp)")
        
        ###Plot genosplit ILs chromosome IV
        data.plot <- filter(Metabolomics_normalized_data,strain_type != "RIL",batch == 9) %>%
            filter(tolower(strain) %in% c("n2","cb4856","wn251","wn252","cbn079","cbn080","cbn081","cbn089")) %>%
            filter(trait_transformation == "Perc.zscore", metabolite == "C18:2") %>%
            mutate(strain = toupper(strain),gen.back=ifelse(grepl("N2",strain_type),"N2\nbackground","CB4856\nbackground"))
        
        ###Significances
        data.test <- spread(select(data.plot,strain,biological,value),key=strain,value=value)
        test.cbn <- apply(data.test[,3:6],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=data.test[,2],alternative="greater")
        test.ewi <- apply(data.test[,8:9],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=data.test[,7],alternative="less")     
        data.test <- data.frame(cbind(strain=names(c(test.cbn,test.ewi)),significance=c(test.cbn,test.ewi))) %>%
            mutate(significance=as.numeric(as.character(unlist(significance)))) %>%
            mutate(p.adjust=p.adjust(significance,method="fdr")) %>%
            mutate(labs=ifelse(p.adjust>0.05,"NS",ifelse(p.adjust<0.001,"***",ifelse(p.adjust<0.01,"**",ifelse(p.adjust<0.05,"*",NA))))) %>%
            merge(select(data.plot,strain,gen.back))
        
        
        p4 <- ggplot(data.plot,aes(x=strain,y=value)) +
            geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
            presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
            geom_text(aes(x=strain,y=4,label=labs,size=3),data=data.test) + 
            facet_grid(.~gen.back,space="free",scales="free") + xlab("Strain") + ylab("C18:2 (z-score)")
        
        ###Actually plot
            ###Blank placeholder
            BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
            
            ###layout
            layout_matrix <- rbind(c(rep(1,1),rep(1,15),rep(2,6)),c(rep(3,15),rep(4,7)))
            
            ###plot              
            pdf(file="Figure_7-C18.2_mQTL.pdf",width=10,height=6); grid.arrange(p1,p2,p3,p4,layout_matrix=layout_matrix) ; dev.off()
            postscript(file="Figure_7-C18.2_mQTL.eps",width=10,height=6); grid.arrange(p1,p2,p3,p4,layout_matrix=layout_matrix) ; dev.off()

            
################################################################################
###IL analysis all traits, chromosome I ########################################

    data.plot <- filter(Metabolomics_normalized_data,strain_type != "RIL",batch == 9) %>%
        filter(tolower(strain) %in% c("n2","cb4856","wn212","wn215","wn217","wn218","cbn021","cbn020","cbn019","cbn017")) %>%
        filter(trait_transformation == "Perc.zscore", !metabolite %in% c("C22:4","C22:5","C27:1","C28:0","C28:1","C29:0","C29:1","C30:0")) %>%
        mutate(strain = toupper(strain),gen.back=ifelse(grepl("N2",strain_type),"N2\nbackground","CB4856\nbackground"))
    
    ###Significances
    data.test <- spread(select(data.plot,metabolite,strain,biological,value),key=strain,value=value)
    
    data.test <- split(data.test,data.test$metabolite)
    test.cbn <- lapply(data.test, function(z){apply(z[,4:7],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[,3],alternative="two.sided")})
    test.ewi <- lapply(data.test, function(z){apply(z[,9:12],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[,8],alternative="two.sided")})    
    data.test <- data.frame(rbind(cbind(strain=names(unlist(test.cbn)),significance=unlist(test.cbn)),
                                  cbind(strain=names(unlist(test.ewi)),significance=unlist(test.ewi)))) %>%
                 separate(strain,into=c("metabolite","strain"),sep="\\.") %>%
                 mutate(significance=as.numeric(as.character(unlist(significance)))) %>%
                 group_by(metabolite) %>%
                 mutate(p.adjust=p.adjust(significance,method="fdr")) %>%
                 mutate(labs=ifelse(p.adjust>0.05,"NS",ifelse(p.adjust<0.001,"***",ifelse(p.adjust<0.01,"**",ifelse(p.adjust<0.05,"*",NA))))) %>%
                 merge(filter(select(data.plot,strain,gen.back),!duplicated(strain)))
       

    
         data.overview <- group_by(data.plot,strain,metabolite,metabolite_fullname) %>%
                          summarise(value=mean(value,na.rm=T)) %>%
                          group_by(metabolite_fullname) %>%
                          group_by(strain) %>%
                          mutate(val.order=median(value)) %>%
                          data.frame() %>%
                          arrange(val.order) %>%
                          mutate(strain=factor(strain,levels=unique(strain))) %>%
                          select(strain,metabolite,metabolite_fullname,value) %>%
                          merge(data.test,by.x=c(1,2),by.y=c(1,2),all.x=TRUE) %>%
                          mutate(labs=ifelse(labs=="NS" | is.na(labs),"",labs)) %>%
                          mutate(gen.back=ifelse(strain=="N2","N2\nbackground",
                                            ifelse(strain=="CB4856","CB4856\nbackground",gen.back)))
         
         
         p1 <- ggplot(data.overview,aes(x=strain,y=metabolite_fullname,fill=value,label=labs)) +
               geom_bin2d() + scale_fill_gradientn(colours=brewer.pal(11,"RdYlBu"),na.value=NA,name="z-score") +
               geom_text() + facet_grid(.~gen.back,scales="free_x",space = "free_x") + presentation + ylab("Metabolite") +
               xlab("Strain") + theme(axis.text.x = element_text(angle = 45, hjust = 1))

         annotation.grob <- title.grob <- textGrob(label = LETTERS[1],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))

         p1 <- arrangeGrob(p1,top=annotation.grob)            
    
         metabolites.plot <- group_by(data.test,metabolite) %>%
                             summarise(n=sum(p.adjust<0.05)) %>%
                             data.frame() %>%
                             filter(n>0)    

        plots <- list(NULL)  
        for(i in 1:nrow(metabolites.plot)){
            met.nu <- metabolites.plot[i,1]
            data.plot.nu <- filter(data.plot,metabolite == met.nu)
            data.test.nu <- filter(data.test,metabolite == met.nu) %>%
                            mutate(value=ceiling(max(data.plot.nu$value,na.rm=T)))
            
            plots[[i]] <- ggplot(data.plot.nu,aes(x=strain,y=value)) +
                          geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
                          presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
                          geom_text(aes(x=strain,y=value,label=labs,size=3),data=data.test.nu) + 
                          facet_grid(metabolite~gen.back,space="free",scales="free") + xlab("Strain") + ylab("abundance (z-score)")

            annotation.grob <- title.grob <- textGrob(label = LETTERS[-1][i],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))

            plots[[i]] <- arrangeGrob(plots[[i]],top=annotation.grob)
        }
    
        layout_matrix <- rbind(c(1,1),c(2,3),c(4,5),c(6,7),c(8,9),c(10,11))
        
        pdf(file="Supplemental_Fig_S3-ChromosomeI_ILs.pdf",width=10,height=20)    
            grid.arrange(p1,
                         plots[[1]],plots[[2]],
                         plots[[3]],plots[[4]],
                         plots[[5]],plots[[6]],
                         plots[[7]],plots[[8]],
                         plots[[9]],plots[[10]],layout_matrix=layout_matrix,heights=c(2,1,1,1,1,1))
        
        dev.off()   
            
        postscript(file="Supplemental_Fig_S3-ChromosomeI_ILs.eps",width=10,height=20)
            grid.arrange(p1,
                         plots[[1]],plots[[2]],
                         plots[[3]],plots[[4]],
                         plots[[5]],plots[[6]],
                         plots[[7]],plots[[8]],
                         plots[[9]],plots[[10]],layout_matrix=layout_matrix,heights=c(2,1,1,1,1,1))
        
        dev.off()   
    
    
    
           
    pdf(file="ChromosomeI_ILs.pdf",width=6,height=4)
        for(i in 1:length(unique(data.plot$metabolite))){
            met.nu <- unique(data.plot$metabolite)[i]
            data.plot.nu <- filter(data.plot,metabolite == met.nu)
            data.test.nu <- filter(data.test,metabolite == met.nu)
            heights <- ceiling(max(data.plot.nu$value)) 
            
    
            print(ggplot(data.plot.nu,aes(x=strain,y=value)) +
                          geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
                          presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
                          geom_text(aes(x=strain,y=heights,label=labs,size=3),data=data.test.nu) + 
                          facet_grid(metabolite~gen.back,space="free",scales="free") + xlab("Strain") + ylab("abundance (z-score)")
            )
        }
    dev.off()    
    
    
################################################################################
###IL analysis all traits, chromosome IV ########################################

            
    data.plot <- filter(Metabolomics_normalized_data,strain_type != "RIL",batch == 9) %>%
        filter(tolower(strain) %in% c("n2","cb4856","wn251","wn252","cbn079","cbn080","cbn081","cbn089")) %>%
        filter(trait_transformation == "Perc.zscore", !metabolite %in% c("C22:4","C22:5","C27:1","C28:0","C28:1","C29:0","C29:1","C30:0")) %>%
        mutate(strain = toupper(strain),gen.back=ifelse(grepl("N2",strain_type),"N2\nbackground","CB4856\nbackground"))
    
    ###Significances
    data.test <- spread(select(data.plot,metabolite,strain,biological,value),key=strain,value=value)
    
    data.test <- split(data.test,data.test$metabolite)
    test.cbn <- lapply(data.test, function(z){apply(z[,4:7],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[,3],alternative="two.sided")})
    test.ewi <- lapply(data.test, function(z){apply(z[,9:10],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[,8],alternative="two.sided")})    
    data.test <- data.frame(rbind(cbind(strain=names(unlist(test.cbn)),significance=unlist(test.cbn)),
                                  cbind(strain=names(unlist(test.ewi)),significance=unlist(test.ewi)))) %>%
        separate(strain,into=c("metabolite","strain"),sep="\\.") %>%
        mutate(significance=as.numeric(as.character(unlist(significance)))) %>%
        group_by(metabolite) %>%
        mutate(p.adjust=p.adjust(significance,method="fdr")) %>%
        mutate(labs=ifelse(p.adjust>0.05,"NS",ifelse(p.adjust<0.001,"***",ifelse(p.adjust<0.01,"**",ifelse(p.adjust<0.05,"*",NA))))) %>%
        merge(filter(select(data.plot,strain,gen.back),!duplicated(strain)))

    
    
         data.overview <- group_by(data.plot,strain,metabolite,metabolite_fullname) %>%
                          summarise(value=mean(value,na.rm=T)) %>%
                          group_by(metabolite_fullname) %>%
                          group_by(strain) %>%
                          mutate(val.order=median(value)) %>%
                          data.frame() %>%
                          arrange(val.order) %>%
                          mutate(strain=factor(strain,levels=unique(strain))) %>%
                          select(strain,metabolite,metabolite_fullname,value) %>%
                          merge(data.test,by.x=c(1,2),by.y=c(1,2),all.x=TRUE) %>%
                          mutate(labs=ifelse(labs=="NS" | is.na(labs),"",labs)) %>%
                          mutate(gen.back=ifelse(strain=="N2","N2\nbackground",
                                            ifelse(strain=="CB4856","CB4856\nbackground",gen.back)))
         
         
         p1 <- ggplot(data.overview,aes(x=strain,y=metabolite_fullname,fill=value,label=labs)) +
               geom_bin2d() + scale_fill_gradientn(colours=brewer.pal(11,"RdYlBu"),na.value=NA,name="z-score") +
               geom_text() + facet_grid(.~gen.back,scales="free_x",space = "free_x") + presentation + ylab("Metabolite") +
               xlab("Strain") + theme(axis.text.x = element_text(angle = 45, hjust = 1))

         annotation.grob <- title.grob <- textGrob(label = LETTERS[1],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))

         p1 <- arrangeGrob(p1,top=annotation.grob)            
    
         metabolites.plot <- group_by(data.test,metabolite) %>%
                             summarise(n=sum(p.adjust<0.05)) %>%
                             data.frame() %>%
                             filter(n>0)    

        plots <- list(NULL)  
        for(i in 1:nrow(metabolites.plot)){
            met.nu <- metabolites.plot[i,1]
            data.plot.nu <- filter(data.plot,metabolite == met.nu)
            data.test.nu <- filter(data.test,metabolite == met.nu) %>%
                            mutate(value=ceiling(max(data.plot.nu$value,na.rm=T)))
            
            plots[[i]] <- ggplot(data.plot.nu,aes(x=strain,y=value)) +
                          geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
                          presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
                          geom_text(aes(x=strain,y=value,label=labs,size=3),data=data.test.nu) + 
                          facet_grid(metabolite~gen.back,space="free",scales="free") + xlab("Strain") + ylab("abundance (z-score)")

            annotation.grob <- title.grob <- textGrob(label = LETTERS[-1][i],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))

            plots[[i]] <- arrangeGrob(plots[[i]],top=annotation.grob)
        }
    
        layout_matrix <- rbind(c(1,1),c(2,3),c(4,5),c(6,7),c(8,9),c(10,11),c(12,13))

        ###Blank placeholder
        BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
        
        pdf(file="Supplemental_Fig_S4-ChromosomeIV_ILs.pdf",width=10,height=23)    
            grid.arrange(p1,
                         plots[[1]],plots[[2]],
                         plots[[3]],plots[[4]],
                         plots[[5]],plots[[6]],
                         plots[[7]],plots[[8]],
                         plots[[9]],plots[[10]],
                         plots[[11]],BlPl,layout_matrix=layout_matrix,heights=c(2.5,1,1,1,1,1,1))
        
        dev.off()   
            
        postscript(file="Supplemental_Fig_S4-ChromosomeIV_ILs.eps",width=10,height=23)
            grid.arrange(p1,
                         plots[[1]],plots[[2]],
                         plots[[3]],plots[[4]],
                         plots[[5]],plots[[6]],
                         plots[[7]],plots[[8]],
                         plots[[9]],plots[[10]],
                         plots[[11]],BlPl,layout_matrix=layout_matrix,heights=c(2.5,1,1,1,1,1,1))
        
        dev.off()   
    

        pdf(file="ChromosomeIV_ILs.pdf",width=6,height=4)
        for(i in 1:length(unique(data.plot$metabolite))){
            met.nu <- unique(data.plot$metabolite)[i]
            data.plot.nu <- filter(data.plot,metabolite == met.nu)
            data.test.nu <- filter(data.test,metabolite == met.nu)
            heights <- ceiling(max(data.plot.nu$value)) 
            
            
            print(
                ggplot(data.plot.nu,aes(x=strain,y=value)) +
                    geom_jitter(height=0,width=0.25,aes(colour=strain_type),alpha=0.6) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=strain_type)) +
                    presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
                    geom_text(aes(x=strain,y=heights,label=labs,size=3),data=data.test.nu) + 
                    facet_grid(metabolite~gen.back,space="free",scales="free") + xlab("Strain") + ylab("abundance (z-score)")
            )
        }
        dev.off()
        

################################################################################
###candidate genes #############################################################
    
    ###load stuff
        load(file=paste(workwd,"/QTL/obj_met.table.QTL.Rdata",sep=""))
    
    ###Keggrest to get pathways
    KEGGs <- read.delim(paste(git_dir,"/Metabolomics/Supporting_files/KEGGpathways.txt",sep=""),colClasses="character")
        KEGGs$KEGGpathway <- paste("cel",KEGGs$KEGGpathway,sep="")
        ###filter for pathways in C. elegans
        KEGGs <- KEGGs[KEGGs[,1] %in% gsub("path:","",names(keggList("pathway","cel"))),]
      
    ###Genetic variation N2 and CB4856
        CB4856.DB <- read.delim(paste(git_dir,"/Metabolomics/Supporting_files/Thompson_2015_Gene_summary.txt",sep="")) %>%
                     group_by(Sequence_name) %>%
                     mutate(gene_polymorf_highimpact=sum(c(Feature_nonsynonymous_substitution:Feature_fully_deleted,Feature_Gene_SNV_splice)),
                            gene_polymorf_regulatory=sum(c(Feature_Gene_.5primeSNVs,Feature_Gene_3primeSNVs,Feature_in_highlydivergent)),
                            gene_polymorf_lowimpact=sum(c(Feature_synonymous_substitution))) %>%
                     select(Sequence_name,Public_name,Gene_coordinates,gene_polymorf_highimpact,gene_polymorf_lowimpact,gene_polymorf_regulatory) %>%
                     separate(Gene_coordinates,into=c("gene_chromosome","gene_bp"),sep=":") %>%
                     separate(gene_bp,into=c("gene_bp","bla"),sep="-") %>%
                     select(-bla) %>%
                     rename(gene_sequence_name=Sequence_name,gene_public_name=Public_name) %>%
                     data.frame()
        for(i in c(1,2,3)){CB4856.DB[,i] <- as.character(unlist(CB4856.DB[,i]))}
        for(i in c(4,5,6,7)){CB4856.DB[,i] <- as.numeric(as.character(unlist(CB4856.DB[,i])))}

        
    ###KEGG         
        genelist <- NULL
        for(i in 1:nrow(KEGGs)){
            tmp <- keggGet(KEGGs[i,1])[[1]]
            
            genelist <- rbind(genelist,cbind(metabolite=KEGGs[i,2],pathway=KEGGs[i,1],specifics=KEGGs[i,3],name=KEGGs[i,4],gene_sequence_name=tmp$GENE[seq(1,length(tmp$GENE),by=2)],gene_other=tmp$GENE[seq(2,length(tmp$GENE),by=2)]))
        }
        genelist <- data.frame(genelist)
            for(i in 1:ncol(genelist)){genelist[,i] <- as.character(unlist(genelist[,i]))}
        #genelist <- tmp
        
    ###Zhang et al; BMC genomics 2013
        zhang <- read.xlsx(paste(git_dir,"/Metabolomics/Supporting_files/Lipid_collection.xlsx",sep=""),sheet=3)
        
        outlist <- mutate(genelist,gene_other=ifelse(!grepl("; ",gene_other),paste(gsub("CELE_","",gene_sequence_name),"; ",gene_other,sep=""),gene_other)) %>%
                   separate(gene_other,into=c("gene_public_name","gene_description"),sep="; ") %>%
                   mutate(gene_sequence_name=gsub("CELE_","",gene_sequence_name)) %>%
                   mutate(gene_sequence_name=ifelse(gene_sequence_name=="cha-1","ZC416.8",gene_sequence_name))
        
        zhang <- filter(zhang,!Gene.ID %in% outlist$gene_sequence_name, !Gene.name %in% outlist$gene_public_name) %>%
                 mutate(metabolite="Fat",pathway=PATHID,specifics="C",name="",gene_sequence_name=Gene.ID,gene_public_name=Gene.name,gene_description=paste("Zhang et al, 2013; ",Predicted.enzyme)) %>%
                 mutate(gene_public_name=ifelse(is.na(gene_public_name),gene_sequence_name,gene_public_name)) %>%
                 select(metabolite,pathway,specifics,name,gene_sequence_name,gene_public_name,gene_description)  
        
        outlist <- rbind(outlist,zhang) %>%
                   merge(CB4856.DB,by.x=5,by.y=1,all.x=TRUE) 
        

        candidates <- NULL
        for(i in 1:nrow(met.table.QTL)){
            tmp <- filter(outlist,gene_chromosome==met.table.QTL$qtl_chromosome[i],gene_bp>met.table.QTL$qtl_bp_left[i],gene_bp<met.table.QTL$qtl_bp_right[i],metabolite==ifelse(met.table.QTL$measurement[i]=="Amino acid","AA","Fat")) %>%
                   mutate(qtl_peak=paste(met.table.QTL$metabolite[i],";",met.table.QTL$qtl_chromosome[i],":",met.table.QTL$qtl_bp_left[i],"-",met.table.QTL$qtl_bp_right[i],sep=""),
                          metabolite_fullname=met.table.QTL$metabolite_fullname[i],
                          metabolite_abbreviation=met.table.QTL$metabolite[i],
                          metabolite_type=met.table.QTL$measurement[i]) %>%
                   filter(ifelse(metabolite_type=="Amino acid",grepl(metabolite_abbreviation[1],specifics),TRUE)) %>%
                   select(qtl_peak:metabolite_type,gene_sequence_name:gene_polymorf_regulatory)
            
            candidates <- rbind(candidates,tmp)
        }
        
            
         candidate_table <- group_by(candidates,qtl_peak) %>%
                            summarise(genes_all=paste(unique(gene_public_name.x),collapse=", "),
                                      genes_polymorf_highimpact=paste(unique(gene_public_name.x[gene_polymorf_highimpact!=0]),collapse=", "),
                                      genes_polymorf_regulatory=paste(unique(gene_public_name.x[gene_polymorf_regulatory!=0]),collapse=", "),
                                      genes_polymorf_lowimpact=paste(unique(gene_public_name.x[gene_polymorf_lowimpact!=0]),collapse=", ")) %>%
                            data.frame()
            

    ###TFs
        TFs <- Enrich.DB.Ce[[5]][[1]][grepl("transcription factor",tolower(Enrich.DB.Ce[[5]][[1]][,2])),1]
            outlist <- filter(gene.identifiers.Ce,gene_WBID %in% TFs) %>%
                       select(gene_public_name:gene_sequence_name) %>%
                       merge(CB4856.DB[,-2],by.x=2,by.y=1)
            
        
        candidates.TF <- NULL
        for(i in 1:nrow(met.table.QTL)){
            tmp <- filter(outlist,gene_chromosome==met.table.QTL$qtl_chromosome[i],gene_bp>met.table.QTL$qtl_bp_left[i],gene_bp<met.table.QTL$qtl_bp_right[i]) %>%
                   mutate(qtl_peak=paste(met.table.QTL$metabolite[i],";",met.table.QTL$qtl_chromosome[i],":",met.table.QTL$qtl_bp_left[i],"-",met.table.QTL$qtl_bp_right[i],sep=""),
                          metabolite_fullname=met.table.QTL$metabolite_fullname[i],
                          metabolite_abbreviation=met.table.QTL$metabolite[i],
                          metabolite_type=met.table.QTL$measurement[i]) %>%
                   select(qtl_peak:metabolite_type,gene_sequence_name:gene_polymorf_regulatory)
            
            candidates.TF <- rbind(candidates.TF,tmp)
        }
        
         candidate_table.TF <- group_by(candidates.TF,qtl_peak) %>%
                                summarise(genes_all=paste(unique(gene_public_name),collapse=", "),
                                          genes_polymorf_highimpact=paste(unique(gene_public_name[gene_polymorf_highimpact!=0]),collapse=", "),
                                          genes_polymorf_regulatory=paste(unique(gene_public_name[gene_polymorf_regulatory!=0]),collapse=", "),
                                          genes_polymorf_lowimpact=paste(unique(gene_public_name[gene_polymorf_lowimpact!=0]),collapse=", ")) %>%
                                data.frame()
                    
     ###Write it
         write.xlsx(candidate_table,file="Supplementary_file_x-candidates_KEGG.xlsx")
         write.xlsx(candidate_table.TF,file="Supplementary_file_x-candidates_TF.xlsx")
         write.xlsx(candidates,file="Supplementary_file_x-candidates_KEGG_complete.xlsx")
         write.xlsx(candidates.TF,file="Supplementary_file_x-candidates_TF_complete.xlsx")
         

################################################################################
### RNAi genes #################################################################
         
    ###Load RNAi data
        load(paste(support_git_dir,"obj_Metabolomics_normalized_RNAi.Rdata",sep=""))         
        head(Metabolomics_normalized_RNAi)
    
    ###The genes
        C14TF <- c("HT115","nhr-165","nhr-169","nhr-174","nhr-217","ces-2","nhr-265","nhr-276","nhr-77","nhr-81","nhr-82") #"oac-45"
        C14met <- c("HT115","acox-1","ech-7","gpdh-1","lagr-1","scrm-2","T27F6.6","Y87G2A.2","F08A8.3","F08A8.4","acox-1.1","acox-1.3","acox-1.4")
        
        
        data.plot <- filter(Metabolomics_normalized_RNAi,strain %in% c(C14TF,C14met)) %>%
                     filter(trait_transformation == "Abs.conc", !metabolite %in% c("C22:4","C22:5","C27:1","C28:0","C28:1","C29:0","C29:1","C30:0")) %>%
                     group_by(batch,metabolite) %>%
                     mutate(mean_batch=mean(value[strain=="HT115"],na.rm=T),sd_batch=sd(value[strain=="HT115"],na.rm=T)) %>%
                     data.frame() %>%
                     mutate(value=(value-mean_batch)/sd_batch) %>%
            
                                 mutate(strain=ifelse(strain=="acox-1","acox-1.1",
                                     ifelse(strain=="F08A8.3","acox-1.3",
                                       ifelse(strain=="F08A8.4","acox-1.4",strain)))) %>%
                     mutate(strain = gsub("\\.","_",strain)) %>%
                     data.frame() %>%
                     filter(metabolite %in% c("C15:1","C14:1","C26:0"))
     
    ###Significances
        data.test <- spread(select(data.plot,metabolite,strain,biological,value),key=strain,value=value)
        
        data.test <- split(data.test,data.test$metabolite)
        test.rnai <- lapply(data.test, function(z){apply(z[,colnames(z)%in% gsub("\\.","_",c(C14met[-1],C14TF))],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[,colnames(z)=="HT115"],alternative="two.sided")})
        
        #test.rnaimet <- lapply(data.test, function(z){apply(z[,colnames(z)%in% gsub("\\.","_",C14met[-1])],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[1:4,colnames(z)=="HT115"],alternative="two.sided")})
        #test.rnaitf <- lapply(data.test, function(z){apply(z[,colnames(z)%in% C14TF[-1]],2,function(x,y,alternative){t.test(x,y,alternative,var.equal = T)$p.value},y=z[5:8,colnames(z)=="HT115"],alternative="two.sided")})
        #data.test <- data.frame(rbind(cbind(strain=names(unlist(test.rnaimet)),significance=unlist(test.rnaimet)),
        #                              cbind(strain=names(unlist(test.rnaitf)),significance=unlist(test.rnaitf)))) %>%
         
        data.test <- data.frame(cbind(strain=names(unlist(test.rnai)),significance=unlist(test.rnai))) %>%
                     separate(strain,into=c("metabolite","strain"),sep="\\.") %>%
                     mutate(significance=as.numeric(as.character(unlist(significance)))) %>%
                     group_by(strain) %>%
                     mutate(p.adjust=p.adjust(significance,method="fdr")) %>%
                     mutate(labs=ifelse(p.adjust>0.05,"NS",ifelse(p.adjust<0.001,"***",ifelse(p.adjust<0.01,"**",ifelse(p.adjust<0.05,"*",NA))))) %>%
                     merge(filter(select(data.plot,strain),!duplicated(strain)))
        
        metabolites.plot <- group_by(data.test,metabolite) %>%
                         summarise(n=sum(p.adjust<0.05)) %>%
                         data.frame() %>%
                         filter(n>0)
        
        data.overview <- group_by(data.plot,strain,metabolite,metabolite_fullname) %>%
                      summarise(value=mean(value,na.rm=T)) %>%
                      #group_by(metabolite_fullname) %>%
                      #mutate(value_HT115=value[strain=="HT115"]) %>%
                      #mutate(value_log=log2(value/value_HT115)) %>%
                      mutate(value_log=value) %>%
                      group_by(metabolite) %>%
                      mutate(val.order=median(value_log)) %>%
                      data.frame() %>%
                      arrange(val.order) %>%
                      mutate(strain=factor(strain,levels=unique(strain))) %>%
                      select(strain,metabolite,metabolite_fullname,value_log) %>%
                      merge(data.test,by.x=c(1,2),by.y=c(1,2)) %>%
                      mutate(labs=ifelse(labs=="NS","",labs)) %>%
                      mutate(strain = gsub("_","\\.",strain)) %>%
                      mutate(strain_type=ifelse(strain %in% C14met,"metabolism","transcription\nfactor")) %>%
                      filter(strain != "HT115")
        
        p1 <- ggplot(data.overview,aes(x=strain,y=metabolite_fullname,fill=value_log,label=labs)) +
              geom_bin2d() + scale_fill_gradientn(colours=brewer.pal(11,"RdYlBu"),na.value=NA,name="log2\n(Strain/HT115)") +
              geom_text() + facet_grid(.~strain_type,scales="free_x",space = "free_x") + presentation + ylab("Metabolite") +
              xlab("Strain") + theme(axis.text.x = element_text(angle = 45, hjust = 1))
        
        annotation.grob <- title.grob <- textGrob(label = LETTERS[1],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
             
        p1 <- arrangeGrob(p1,top=annotation.grob)            

        
        plots <- list(NULL)  
        for(i in 1:nrow(metabolites.plot)){
            met.nu <- metabolites.plot[i,1]
            data.plot.nu <- filter(data.plot,metabolite == met.nu) %>%
                            group_by(strain) %>%
                            mutate(med_strain=median(value,na.rm=T)) %>%
                            data.frame() %>%
                            arrange(med_strain) %>%
                            mutate(strain = gsub("_","\\.",strain)) %>%
                            mutate(strain=factor(strain,levels=unique(strain))) 
            data.test.nu <- filter(data.test,metabolite == met.nu) %>%
                            mutate(value=ceiling(max(data.plot.nu$value,na.rm=T))) %>%
                            mutate(strain = gsub("_","\\.",strain))
         
         
            plots[[i]] <- ggplot(data.plot.nu,aes(x=strain,y=value)) +
                          geom_jitter(height=0,width=0.25,alpha=0.6,aes(colour=ifelse(strain=="HT115","N2","RIL"))) + geom_boxplot(outlier.shape=NA,alpha=0.6,aes(fill=ifelse(strain=="HT115","N2","RIL"))) +
                          presentation + colScale + fillScale + theme(axis.text.x = element_text(angle = 45, hjust = 1),legend.position = "none") + 
                          geom_text(aes(x=strain,y=value,label=labs,size=3),data=data.test.nu) + 
                          facet_grid(metabolite~.,space="free",scales="free") + xlab("Strain") + ylab("concentration")        
                          annotation.grob <- title.grob <- textGrob(label = LETTERS[-1][i],x = unit(0, "lines"),y = unit(0, "lines"),hjust = 0, vjust = 0,gp = gpar(fontsize = 20,fontface="bold"))
        
            plots[[i]] <- arrangeGrob(plots[[i]],top=annotation.grob)
        }
        
        layout_matrix <- rbind(c(1,1),c(2,3),c(4,5))
        
        ###Blank placeholder
        BlPl <- ggplot()+geom_blank(aes(1,1))+ blank_theme
        
        pdf(file="Supplemental_Fig_S5-RNAi_genes_v2.pdf",width=10,height=12)    
           grid.arrange(p1,
                         plots[[1]],plots[[2]],
                         plots[[3]],BlPl,layout_matrix=layout_matrix,heights=c(1.5,1,1))
        
        dev.off()   
            
        postscript(file="Supplemental_Fig_S5-RNAi_genes_v2.eps",width=10,height=23)
        grid.arrange(p1,
                     plots[[1]],plots[[2]],
                     plots[[3]],BlPl,layout_matrix=layout_matrix,heights=c(1.5,1,1))
        dev.off()   
             

################################################################################
### IL pleiotropy ##############################################################
### Reviewer question
         
         ###load stuff
         load(file=paste(workwd,"/QTL/obj_met.table.QTL.Rdata",sep=""))
         
         #n2","cb4856","wn212","wn215","wn217","wn218","cbn021","cbn020","cbn019","cbn017"
         data.plot <- prep.ggplot.genetic.map(strain.map=popmap,strain.marker=popmrk) %>% 
                      #filter(tolower(strain) %in% c("n2","cb4856","wn212","wn215","wn217")) %>%
                      rbind(filter(cbnmap)) %>% #,strain %in% c("cbn021","cbn020","cbn019","cbn017","wn218"))) %>%
                      mutate(index=as.numeric(as.factor(strain)),genotype_name=ifelse(genotype==-1,"CB4856",ifelse(genotype==1,"N2",NA))) %>%
                      filter(chromosome != "MtDNA") %>%
                      filter((position_end-position_start)>1e5)
         
         table.QTL <- rename(met.table.QTL,trait = metabolite)
                     
         
         tmp <- predict.QTL(data.plot,table.QTL) %>%
                mutate(strain=toupper(strain))
         
         
         data.plot <- filter(Metabolomics_normalized_data)%>%#,strain_type != "RIL",batch == 9) %>%
            # filter(tolower(strain) %in% c("n2","cb4856","wn251","wn252","cbn079","cbn080","cbn081","cbn089")) %>%
             filter(trait_transformation == "Perc.zscore") %>%
             mutate(strain = toupper(strain),gen.back=ifelse(grepl("N2",strain_type),"N2\nbackground","CB4856\nbackground")) %>%
             merge(tmp,by.x=c(4,1),by.y=c(1,2)) %>%
             group_by(strain,metabolite,Data_type,strain_type,gen.back,metabolite_fullname,trait_predict) %>%
             summarise(trait_experimental=mean(value),trait_experimental_se=sd(value)/sqrt(length(value))) %>%
             data.frame() %>%
             mutate(trait_predict=trait_predict) %>%
             group_by(strain) %>%
             mutate(correlation=cor(trait_experimental,trait_predict),
                    slope_lm=coefficients(lm(trait_experimental~trait_predict))[2],
                    intercept_lm=coefficients(lm(trait_experimental~trait_predict))[1]) %>%
             data.frame()
             
         
         pdf(file="pleiotropic_ILs.pdf",width=9,height=4) 
         ggplot(data.plot,aes(x=trait_predict,y=trait_experimental,group=strain,alpha=0.2)) +
             geom_point() + geom_segment(aes(x=trait_predict,xend=trait_predict,y=trait_experimental-trait_experimental_se,yend=trait_experimental+trait_experimental_se)) + 
             facet_wrap(~strain_type) + geom_line(stat="smooth",method="lm",colour="blue") + xlim(-1.5,2.5) + ylim(-1.5,2.5) +
             geom_abline(slope=1,intercept=0,lty=2) + presentation
         dev.off()
         
         predict.QTL <- function(prep.ggplot.object,table.QTL){
                                 mismatch_factor <- 2
                                 byx <- which(colnames(prep.ggplot.object) == "chromosome")
                                 byy <- which(colnames(table.QTL) == "qtl_chromosome")
                                 
                                
                                 
                                 output <- merge(prep.ggplot.object,table.QTL,by.x=byx,by.y=byy) %>%
                                           filter(position_start < qtl_bp, position_end > qtl_bp) %>%
                                           mutate(trait_value = as.numeric(as.character(unlist(genotype))) * as.numeric(as.character(unlist(qtl_effect)))) %>%
                                           group_by(strain,trait) %>%
                                           summarise(trait_predict=sum(trait_value)) %>%
                                           data.frame()
                                 return(output)
                                }
         
         
         data.test <- prep.ggplot.QTL.profile(QTL.peak.output = met.peak.QTL, map1.output = met.QTL,trait="Perc.zscore_C26:0")
         
         data.plot <- data.test[[1]]
         
         p1 <- ggplot(data.plot,aes(x=qtl_bp,y=qtl_significance)) + geom_hline(yintercept=3.7,linetype=2,size=1) +
             geom_line(size=2) + facet_grid(.~qtl_chromosome,scales="free",space="free") + 
             presentation + scale_x_continuous(breaks=c(5,10,15,20)*10^6,labels=c(5,10,15,20)) + xlab("mQTL location (Mbp)") + ylab("\nsignificance (-log10(p))")
         
         

         
         
    
    
    
    
    
    
            
         
         
                     